//=============================================================================
// RPG Maker MZ - Suppress Cursor Flash
//=============================================================================
// Author: Mooglerampage (Chris Williams)
// Developed Jan 2022 - alpha version


var Imported = Imported || {};
Imported.MoogleSuppressCursorFlash = true;

var Mooglerampage = Mooglerampage || {};        // Mooglerampage main
Mooglerampage.FC = Mooglerampage.FC || {};      // This plugin object
Mooglerampage.FC.pluginName = "MoogleSuppressCursorFlash";


/*:
 * @target MZ
 * @plugindesc Prevents the highlight over selected items from flashing - modified to flash more slowly instead of static
 * @author mooglerampage, adapted to MZ from code posted to RM forums by jchedges
 *
 * @param FlashInterval
 * @default 90
 * @text The time between flashes
 * @desc Changing this will affect the frequency of flashes; set to 0 to disable flash
 *
 * 
 */



Window.prototype._makeCursorAlpha = function() {
    const blinkCount = this._animationCount % PluginManager.parameters('MoogleSuppressCursorFlash').FlashInterval;
    const baseAlpha = this.contentsOpacity / 255;
    if (this.active) {
        if (blinkCount < 20) {
            return baseAlpha - blinkCount / 32;
        } else {
            return baseAlpha - (40 - blinkCount) / 32;
        }
    }
    return baseAlpha;
};